/*
 * Decompiled with CFR 0.152.
 */
package shared;

import java.util.Comparator;
import java.util.HashSet;
import shared.Pair;

public class Node {
    private final Pair label;
    private final HashSet<Node> linkedNodes;
    private String tag;

    public Node(Pair pair) {
        this.label = pair;
        this.linkedNodes = new HashSet();
    }

    public String toString() {
        return this.label.toString();
    }

    public String toTag(boolean b) {
        return b ? this.tag : this.label.toString();
    }

    public HashSet<Node> getLinkedNodes() {
        return this.linkedNodes;
    }

    public Pair getLabel() {
        return this.label;
    }

    public void setTag(String tag) {
        this.tag = tag;
    }

    public boolean includes(Node n2) {
        return this.label.includes(n2.label);
    }

    public boolean isColored(String s) {
        return this.label.contains(s);
    }

    public static class NodeComparator
    implements Comparator<Node> {
        @Override
        public int compare(Node o1, Node o2) {
            return o1.label.getAttributesSize() - o2.label.getAttributesSize();
        }
    }
}

